create or replace package tbicds.PCK_REPORTS_STAT
AUTHID CURRENT_USER 
is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
 --type defs to return recordsets
  type RetRefCursor is ref cursor;
  type refCursor is ref cursor;

  procedure CreateExportRequestRS(pi_vSessionID         in varchar2,
                                  pi_vSessionClientIP   in varchar2,
                                  pi_nUserID            in number,
                                  pi_vExportRequestName in varchar2,
                                  po_nStatusCode        out number,
                                  po_vStatusComment     out varchar2,
                                  rs                    out RetRefCursor);

  procedure GetMyRequestRS(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out RetRefCursor);

  procedure RenameExportRequest(pi_vSessionID            in varchar2,
                                pi_vSessionClientIP      in varchar2,
                                pi_nUserID               in number,
                                pi_nRequestID            in number,
                                pi_vNewExportRequestName in varchar2,
                                po_nStatusCode           out number,
                                po_vStatusComment        out varchar2);

  procedure UpdateExportRequest(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nRequestID       in number,
                                pi_vFilters         in varchar2,
                                pi_vDataFields      in varchar2,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2);

  procedure GetExportRequestRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_nRequestID       in number,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor);

  procedure SaveAsExportRequest(pi_vSessionID         in varchar2,
                                pi_vSessionClientIP   in varchar2,
                                pi_nUserID            in number,
                                pi_vExportRequestName in varchar2,
                                pi_vFilters         in varchar2,
                                pi_vDataFields      in varchar2,
                                po_nStatusCode        out number,
                                po_vStatusComment     out varchar2);
                                
  procedure SubmitExportRequest(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vKey             in varchar2,
                                pi_nRequestID       in number,
                                pi_vFilters         in varchar2,
                                pi_vDataFields      in varchar2,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2);
                                
  procedure CancelExportRequest(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nRequestID       in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2);
                                
  procedure GetExportRequestCSVFileRS(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      pi_nRequestID       in number,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2,
                                      rs                  out RetRefCursor);

  procedure SubmitNewExportRequest(pi_vSessionID         in varchar2,
                                   pi_vSessionClientIP   in varchar2,
                                   pi_nUserID            in number,
                                   pi_vKey               in varchar2,
                                   pi_vExportRequestName in varchar2,
                                   pi_vFilters           in varchar2,
                                   pi_vDataFields        in varchar2,
                                   po_nStatusCode        out number,
                                   po_vStatusComment     out varchar2);
                                   
end PCK_REPORTS_STAT;
/

